/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements.jdbc;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.statements.api.ExposedConnection;
import org.jetbrains.exposed.sql.statements.api.ExposedDatabaseMetadata;
import org.jetbrains.exposed.sql.statements.api.ExposedSavepoint;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcDatabaseMetadataImpl;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcPreparedStatementImpl;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcSavepoint;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010/\u001a\u00020\u0002\u00a2\u0006\u0004\bC\u0010DJ\u000f\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0005J\u001d\u0010\n\u001a\u00020\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ.\u0010\u0011\u001a\u00028\u0000\"\u0004\b\u0000\u0010\f2\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00000\r\u00a2\u0006\u0002\b\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J%\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u001bJ\u0017\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b \u0010\u0005J\u0017\u0010 \u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b \u0010\u001fJ\u0017\u0010\"\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\"\u0010#R$\u0010)\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u00198V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R$\u0010.\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010/\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010&R\u001b\u0010\u0011\u001a\u0002048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b7\u00108R$\u0010;\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b9\u0010+\"\u0004\b:\u0010-R*\u0010=\u001a\u00020<2\u0006\u0010$\u001a\u00020<8\u0016@VX\u0096\u000e\u00a2\u0006\u0012\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@\"\u0004\bA\u0010B\u00a8\u0006E"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcConnectionImpl;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "Ljava/sql/Connection;", "", "close", "()V", "commit", "", "", "sqls", "executeInBatch", "(Ljava/util/List;)V", "T", "Lkotlin/Function1;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedDatabaseMetadata;", "Lkotlin/ExtensionFunctionType;", "body", "metadata", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "sql", "", "columns", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "prepareStatement", "(Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "", "returnKeys", "(Ljava/lang/String;Z)Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedSavepoint;", "savepoint", "releaseSavepoint", "(Lorg/jetbrains/exposed/sql/statements/api/ExposedSavepoint;)V", "rollback", "name", "setSavepoint", "(Ljava/lang/String;)Lorg/jetbrains/exposed/sql/statements/api/ExposedSavepoint;", "value", "getAutoCommit", "()Z", "setAutoCommit", "(Z)V", "autoCommit", "getCatalog", "()Ljava/lang/String;", "setCatalog", "(Ljava/lang/String;)V", "catalog", "connection", "Ljava/sql/Connection;", "getConnection", "()Ljava/sql/Connection;", "isClosed", "Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;", "metadata$delegate", "Lkotlin/Lazy;", "getMetadata", "()Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;", "getSchema", "setSchema", "schema", "", "transactionIsolation", "I", "getTransactionIsolation", "()I", "setTransactionIsolation", "(I)V", "<init>", "(Ljava/sql/Connection;)V", "exposed-jdbc"})
public final class JdbcConnectionImpl
implements ExposedConnection<Connection> {
    @NotNull
    private final Connection connection;
    private int transactionIsolation;
    @NotNull
    private final Lazy metadata$delegate;

    public JdbcConnectionImpl(@NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.connection = connection;
        this.transactionIsolation = this.getConnection().getTransactionIsolation();
        this.metadata$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JdbcDatabaseMetadataImpl>(this){
            final /* synthetic */ JdbcConnectionImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final JdbcDatabaseMetadataImpl invoke() {
                String string = this.this$0.getCatalog();
                DatabaseMetaData databaseMetaData = this.this$0.getConnection().getMetaData();
                Intrinsics.checkNotNullExpressionValue((Object)databaseMetaData, (String)"connection.metaData");
                return new JdbcDatabaseMetadataImpl(string, databaseMetaData);
            }
        }));
    }

    @Override
    @NotNull
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    @NotNull
    public String getCatalog() {
        String string;
        String string2;
        String string3;
        try {
            string3 = this.getConnection().getCatalog();
        }
        catch (Exception _) {
            string3 = null;
        }
        if ((string2 = string3) == null) {
            string2 = string = this.getConnection().getMetaData().getUserName();
        }
        if (string2 == null) {
            string = "";
        }
        return string;
    }

    @Override
    public void setCatalog(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        try {
            this.getConnection().setCatalog(value2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public String getSchema() {
        String string;
        try {
            string = this.getConnection().getSchema();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{ connection.schema }");
        }
        catch (Exception _) {
            string = "";
        }
        return string;
    }

    @Override
    public void setSchema(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        try {
            this.getConnection().setSchema(value2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void commit() {
        this.getConnection().commit();
    }

    @Override
    public void rollback() {
        this.getConnection().rollback();
    }

    @Override
    public boolean isClosed() {
        return this.getConnection().isClosed();
    }

    @Override
    public void close() {
        this.getConnection().close();
    }

    @Override
    public boolean getAutoCommit() {
        return this.getConnection().getAutoCommit();
    }

    @Override
    public void setAutoCommit(boolean value2) {
        this.getConnection().setAutoCommit(value2);
    }

    @Override
    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    @Override
    public void setTransactionIsolation(int value2) {
        if (this.transactionIsolation != value2) {
            this.getConnection().setTransactionIsolation(value2);
            this.transactionIsolation = value2;
        }
    }

    private final JdbcDatabaseMetadataImpl getMetadata() {
        Lazy lazy2 = this.metadata$delegate;
        return (JdbcDatabaseMetadataImpl)lazy2.getValue();
    }

    @Override
    public <T> T metadata(@NotNull Function1<? super ExposedDatabaseMetadata, ? extends T> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return (T)body.invoke((Object)this.getMetadata());
    }

    @Override
    @NotNull
    public PreparedStatementApi prepareStatement(@NotNull String sql2, boolean returnKeys) {
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        int generated = returnKeys ? 1 : 2;
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(sql2, generated);
        Intrinsics.checkNotNullExpressionValue((Object)preparedStatement, (String)"connection.prepareStatement(sql, generated)");
        return new JdbcPreparedStatementImpl(preparedStatement, returnKeys);
    }

    @Override
    @NotNull
    public PreparedStatementApi prepareStatement(@NotNull String sql2, @NotNull String[] columns2) {
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        Intrinsics.checkNotNullParameter((Object)columns2, (String)"columns");
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(sql2, columns2);
        Intrinsics.checkNotNullExpressionValue((Object)preparedStatement, (String)"connection.prepareStatement(sql, columns)");
        return new JdbcPreparedStatementImpl(preparedStatement, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void executeInBatch(@NotNull List<String> sqls) {
        boolean bl;
        List types;
        Object object;
        block8: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(sqls, (String)"sqls");
            Iterable $this$map$iv = sqls;
            boolean $i$f$map = false;
            object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                StatementType statementType;
                Collection collection;
                block7: {
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    for (StatementType statementType2 : StatementType.values()) {
                        void stmt;
                        StatementType it = statementType2;
                        boolean bl3 = false;
                        if (!StringsKt.startsWith((String)stmt, (String)it.name(), (boolean)true)) continue;
                        statementType = statementType2;
                        break block7;
                    }
                    statementType = null;
                }
                StatementType statementType3 = statementType;
                collection.add(statementType3 == null ? StatementType.OTHER : statementType3);
            }
            types = (List)destination$iv$iv;
            Iterable $this$none$iv = types;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    StatementType it = (StatementType)((Object)element$iv);
                    boolean bl4 = false;
                    if (!(it == StatementType.SELECT)) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean $i$a$-check-JdbcConnectionImpl$executeInBatch$32 = false;
            String $i$a$-check-JdbcConnectionImpl$executeInBatch$32 = "SELECT statements are unsupported in batch execution";
            throw new IllegalStateException($i$a$-check-JdbcConnectionImpl$executeInBatch$32.toString());
        }
        StatementType statementType = (StatementType)((Object)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)types)));
        if (statementType == null) {
            statementType = StatementType.OTHER;
        }
        StatementType type = statementType;
        object = CollectionsKt.emptyList();
        Statement<Unit> prepStatement2 = new Statement<Unit>(type, this, sqls, (List<? extends Table>)object){
            final /* synthetic */ StatementType $type;
            final /* synthetic */ JdbcConnectionImpl this$0;
            final /* synthetic */ List<String> $sqls;
            {
                this.$type = $type;
                this.this$0 = $receiver;
                this.$sqls = $sqls;
                super($type, $super_call_param$1);
            }

            @NotNull
            public PreparedStatementApi prepared(@NotNull Transaction transaction2, @NotNull String sql2) {
                Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
                Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
                PreparedStatementApi originalStatement = super.prepared(transaction2, StringsKt.substringBefore$default((String)sql2, (char)'\n', null, (int)2, null));
                java.sql.Statement statement = this.this$0.getConnection().createStatement();
                List<String> list2 = this.$sqls;
                java.sql.Statement $this$prepared_u24lambda_u2d1 = statement;
                boolean bl = false;
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    $this$prepared_u24lambda_u2d1.addBatch(it);
                }
                java.sql.Statement batchStatement = statement;
                return new PreparedStatementApi(originalStatement, batchStatement){
                    private final /* synthetic */ PreparedStatementApi $$delegate_0;
                    final /* synthetic */ PreparedStatementApi $originalStatement;
                    final /* synthetic */ java.sql.Statement $batchStatement;
                    {
                        this.$originalStatement = $originalStatement;
                        this.$batchStatement = $batchStatement;
                        this.$$delegate_0 = this.$originalStatement;
                    }

                    @Nullable
                    public Integer getFetchSize() {
                        return this.$$delegate_0.getFetchSize();
                    }

                    public void setFetchSize(@Nullable Integer n) {
                        this.$$delegate_0.setFetchSize(n);
                    }

                    @Nullable
                    public ResultSet getResultSet() {
                        return this.$$delegate_0.getResultSet();
                    }

                    public void addBatch() {
                        this.$$delegate_0.addBatch();
                    }

                    public void cancel() {
                        this.$$delegate_0.cancel();
                    }

                    @NotNull
                    public List<Integer> executeBatch() {
                        return this.$$delegate_0.executeBatch();
                    }

                    @NotNull
                    public ResultSet executeQuery() {
                        return this.$$delegate_0.executeQuery();
                    }

                    public int fillParameters(@NotNull Iterable<? extends Pair<? extends IColumnType, ? extends Object>> args) {
                        Intrinsics.checkNotNullParameter(args, (String)"args");
                        return this.$$delegate_0.fillParameters(args);
                    }

                    public void set(int index, @NotNull Object value2) {
                        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                        this.$$delegate_0.set(index, value2);
                    }

                    public void setInputStream(int index, @NotNull InputStream inputStream) {
                        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
                        this.$$delegate_0.setInputStream(index, inputStream);
                    }

                    public void setNull(int index, @NotNull IColumnType columnType) {
                        Intrinsics.checkNotNullParameter((Object)columnType, (String)"columnType");
                        this.$$delegate_0.setNull(index, columnType);
                    }

                    public void closeIfPossible() {
                        this.$batchStatement.close();
                        this.$originalStatement.closeIfPossible();
                    }

                    public int executeUpdate() {
                        this.$batchStatement.executeBatch();
                        return 0;
                    }
                };
            }

            public void executeInternal(@NotNull PreparedStatementApi $this$executeInternal, @NotNull Transaction transaction2) {
                Intrinsics.checkNotNullParameter((Object)$this$executeInternal, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
                $this$executeInternal.executeUpdate();
            }

            @NotNull
            public String prepareSQL(@NotNull Transaction transaction2) {
                Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
                return CollectionsKt.joinToString$default((Iterable)this.$sqls, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            }

            @NotNull
            public Iterable<Iterable<Pair<ColumnType, Object>>> arguments() {
                return CollectionsKt.emptyList();
            }
        };
        prepStatement2.execute(TransactionManager.Companion.current());
    }

    @Override
    @NotNull
    public ExposedSavepoint setSavepoint(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Savepoint savepoint = this.getConnection().setSavepoint(name);
        Intrinsics.checkNotNullExpressionValue((Object)savepoint, (String)"connection.setSavepoint(name)");
        return new JdbcSavepoint(name, savepoint);
    }

    @Override
    public void releaseSavepoint(@NotNull ExposedSavepoint savepoint) {
        Intrinsics.checkNotNullParameter((Object)savepoint, (String)"savepoint");
        this.getConnection().releaseSavepoint(((JdbcSavepoint)savepoint).getSavepoint$exposed_jdbc());
    }

    @Override
    public void rollback(@NotNull ExposedSavepoint savepoint) {
        Intrinsics.checkNotNullParameter((Object)savepoint, (String)"savepoint");
        this.getConnection().rollback(((JdbcSavepoint)savepoint).getSavepoint$exposed_jdbc());
    }
}

